<script type="text/javascript" language="javascript" >
    $(document).ready(function() {
        $('#example').DataTable( {
            "processing": true,
            "serverSide": true,
            "order": [[ 0, "desc" ]],
            "ajax": "datafiles/orders_data<?= (isset($p['id']) && !empty($p['id']))?'?st='.$p['id']:''; ?>",
            "responsive": true,
            "stateSave": true,
            "autoWidth":false,
            "columnDefs": [{ width: '2%',targets:0},{ width: '5%',targets:1},{ width: '5%',targets:2},{ width: '3%',targets:4},{ width: '3%',targets:5},{ width: '3%',targets:6},{ width: '3%',targets:7}],
            "columns":[
                { data:0 },
                { data:8 },
                { 
                    data: null,
                    render:function(data)
                    {
                       var a='';

                        var obj=JSON.parse(data[2]);
                        a+=obj['fname']+obj['lname']+'<br>';
                        a+='<a href="mailto:'+obj['email']+'">'+obj['email']+'</a><br>';
                        a+='<a href="tel:'+obj['phone']+'">'+obj['phone']+'</a><br>';
                        return a;
                    }
                }, 
                { 
                    data: null,
                    render:function(data){
                        var a='';
                        var obj=JSON.parse(data[3]);
                        for(var i=0;i<obj.length;i++){
                            a+='<img src="uploads/'+obj[i]['img']+'" width="50"/>&nbsp;&nbsp;';
                            a+='<a href="<?= PATH; ?>pd/'+obj[i]['url_slug']+'" target="_blank">'+obj[i]['name']+'</a> x '+obj[i]['qty']+'<br>';
                            a+='<hr>';
                        }
                        return a;
                    }
                },
                {data:6},
                {data:5},
                { 
                    data: null,
                    render:function(data)
                    {
                        var a='';
                        switch(data[7]){
                            case 1:
                                a+='<span class="badge rounded-pill bg-warning">New Order</span>';
                                break;
                                
                            case 2:
                                a+='<span class="badge rounded-pill bg-primary">Accepted/Processing</span>';
                                break;
                                
                            case 3:
                                a+='<span class="badge rounded-pill bg-info">Shipped</span>';
                                break;
                                
                            case 4:
                                a+='<span class="badge rounded-pill bg-success">Delivered</span>';
                                break;
                                
                            case 5:
                                a+='<span class="badge rounded-pill bg-danger">Cancelled</span>';
                                break;
                                
                            case 6:
                                a+='<span class="badge rounded-pill bg-secondary">Returned</span>';
                                break;
                                
                            case 7:
                                a+='<span class="badge rounded-pill bg-danger">Abandoned Cart</span>';
                                break;
                        }

                        return a;
                    }
                },
                { 
                    data: null,
                    render:function(data){
                        var id="&id="+data[0];
                        return custombtn('show',"window.location.href='home/singleorder/"+data[0]+"'");
                    }
                }
            ] 
        } );
    } );
</script>

<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Orders</div>

            <div class="ms-auto">
                <div class="btn-group">
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/1'">New Order</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/2'">Accepted/In Process</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/3'">In Transit</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/4'">Delivered</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/5'">Cancelled</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders/99'">Payment Pending</button>
                        <button class="btn btn-outline-secondary px-3 radius-30 btn-sm" onclick="window.location.href='home/orders'">All</button>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <hr/>
        <div class="card">
            <div class="card-body">
                
                <div class="table-responsive">
                    <table id="example" class="table" style="width:100%">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Date</th>
                                <th>User Details</th>
                                <th>Products</th>
                                <th>Total</th>
                                <th>Payment Status</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
